/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlockEntity;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.Nullable;

public class SpeakerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final MapCodec<SpeakerBlock> CODEC = SpeakerBlock.simpleCodec(SpeakerBlock::new);
    private static final BlockEntityTicker<SpeakerBlockEntity> serverTicker = (level, pos, state, drive) -> drive.serverTick();

    public SpeakerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> properties) {
        properties.add(new Property[]{FACING});
    }

    protected MapCodec<? extends SpeakerBlock> codec() {
        return CODEC;
    }

    public @Nullable BlockState getStateForPlacement(BlockPlaceContext placement) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placement.getHorizontalDirection().getOpposite());
    }

    public <U extends BlockEntity> @Nullable BlockEntityTicker<U> getTicker(Level level, BlockState state, BlockEntityType<U> type) {
        return level.isClientSide ? null : BlockEntityHelpers.createTickerHelper(type, (BlockEntityType)ModRegistry.BlockEntities.SPEAKER.get(), serverTicker);
    }

    public @Nullable BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModRegistry.BlockEntities.SPEAKER.get()).create(pos, state);
    }
}

